<?php
/* This file has been auto-generated. Do not edit this file directly. */
namespace SabaiApps\Directories\Component\Entity\Model\Base;

use SabaiApps\Framework\Model\Model;

abstract class FieldGateway extends \SabaiApps\Framework\Model\AbstractGateway
{
    public function getName()
    {
        return 'entity_field';
    }

    public function getFields()
    {
        return ['field_data' => Model::KEY_TYPE_TEXT, 'field_id' => Model::KEY_TYPE_INT, 'field_created' => Model::KEY_TYPE_INT, 'field_updated' => Model::KEY_TYPE_INT, 'field_bundle_name' => Model::KEY_TYPE_VARCHAR, 'field_fieldconfig_name' => Model::KEY_TYPE_VARCHAR];
    }

    protected function _getIdFieldName()
    {
        return 'field_id';
    }

    protected function _getSelectByIdQuery($id, $fields)
    {
        return sprintf(
            'SELECT %s FROM %sentity_field WHERE field_id = %d',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            $id
        );
    }

    protected function _getSelectByIdsQuery($ids, $fields)
    {
        return sprintf(
            'SELECT %s FROM %sentity_field WHERE field_id IN (%s)',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            implode(', ', array_map('intval', $ids))
        );
    }

    protected function _getSelectByCriteriaQuery($criteriaStr, $fields)
    {
        return sprintf(
            'SELECT %1$s FROM %2$sentity_field entity_field WHERE %3$s',
            empty($fields) ? '*' : implode(', ', $fields),
            $this->_db->getResourcePrefix(),
            $criteriaStr
        );
    }

    protected function _getInsertQuery(&$values)
    {
        $values['field_created'] = time();
        $values['field_updated'] = 0;
        return sprintf('INSERT INTO %sentity_field(field_data, field_id, field_created, field_updated, field_bundle_name, field_fieldconfig_name) VALUES(%s, %s, %d, %d, %s, %s)', $this->_db->getResourcePrefix(), $this->_db->escapeString(serialize($values['field_data'])), empty($values['field_id']) ? 'NULL' : intval($values['field_id']), $values['field_created'], $values['field_updated'], $this->_db->escapeString($values['field_bundle_name']), $this->_db->escapeString($values['field_fieldconfig_name']));
    }

    protected function _getUpdateQuery($id, $values)
    {
        $last_update = $values['field_updated'];
        $values['field_updated'] = time();
        return sprintf('UPDATE %sentity_field SET field_data = %s, field_updated = %d, field_bundle_name = %s, field_fieldconfig_name = %s WHERE field_id = %d AND field_updated = %d', $this->_db->getResourcePrefix(), $this->_db->escapeString(serialize($values['field_data'])), $values['field_updated'], $this->_db->escapeString($values['field_bundle_name']), $this->_db->escapeString($values['field_fieldconfig_name']), $id, $last_update);
    }

    protected function _getDeleteQuery($id)
    {
        return sprintf('DELETE FROM %1$sentity_field WHERE field_id = %2$d', $this->_db->getResourcePrefix(), $id);
    }

    protected function _getUpdateByCriteriaQuery($criteriaStr, $sets)
    {
        $sets['field_updated'] = 'field_updated=' . time();
        return sprintf('UPDATE %sentity_field entity_field SET %s WHERE %s', $this->_db->getResourcePrefix(), implode(', ', $sets), $criteriaStr);
    }

    protected function _getDeleteByCriteriaQuery($criteriaStr)
    {
        return sprintf('DELETE entity_field FROM %1$sentity_field entity_field WHERE %2$s', $this->_db->getResourcePrefix(), $criteriaStr);
    }

    protected function _getCountByCriteriaQuery($criteriaStr)
    {
        return sprintf('SELECT COUNT(*) FROM %1$sentity_field entity_field WHERE %2$s', $this->_db->getResourcePrefix(), $criteriaStr);
    }

    protected function _afterInsert1($id, array $new)
    {
    }

    protected function _afterDelete1($id, array $old)
    {
    }

    protected function _afterUpdate1($id, array $new, array $old)
    {
    }

    protected function _afterInsert($id, array $new)
    {
        $this->_afterInsert1($id, $new);
    }

    protected function _afterUpdate($id, array $new, array $old)
    {
        $this->_afterUpdate1($id, $new, $old);
    }

    protected function _afterDelete($id, array $old)
    {
        $this->_afterDelete1($id, $old);
    }
}